/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader;

import dev.quantumfusion.dashloader.DashDataManager;
import dev.quantumfusion.dashloader.DashObjectClass;
import dev.quantumfusion.dashloader.ProfilerHandler;
import dev.quantumfusion.dashloader.ProgressHandler;
import dev.quantumfusion.dashloader.api.APIHandler;
import dev.quantumfusion.dashloader.api.hook.LoadCacheHook;
import dev.quantumfusion.dashloader.api.hook.SaveCacheHook;
import dev.quantumfusion.dashloader.client.DashCachingScreen;
import dev.quantumfusion.dashloader.config.ConfigHandler;
import dev.quantumfusion.dashloader.data.DashIdentifier;
import dev.quantumfusion.dashloader.data.DashIdentifierInterface;
import dev.quantumfusion.dashloader.data.DashModelIdentifier;
import dev.quantumfusion.dashloader.data.MappingData;
import dev.quantumfusion.dashloader.data.blockstate.DashBlockState;
import dev.quantumfusion.dashloader.data.font.DashFont;
import dev.quantumfusion.dashloader.data.image.DashImage;
import dev.quantumfusion.dashloader.data.image.DashSprite;
import dev.quantumfusion.dashloader.data.model.DashModel;
import dev.quantumfusion.dashloader.data.model.components.DashBakedQuad;
import dev.quantumfusion.dashloader.data.model.predicates.DashPredicate;
import dev.quantumfusion.dashloader.data.registry.BakedQuadData;
import dev.quantumfusion.dashloader.data.registry.IdentifierData;
import dev.quantumfusion.dashloader.data.registry.ImageData;
import dev.quantumfusion.dashloader.data.registry.ModelData;
import dev.quantumfusion.dashloader.data.registry.RegistryData;
import dev.quantumfusion.dashloader.fallback.model.DashMissingDashModel;
import dev.quantumfusion.dashloader.io.IOHandler;
import dev.quantumfusion.dashloader.registry.ChunkHolder;
import dev.quantumfusion.dashloader.registry.RegistryHandler;
import dev.quantumfusion.dashloader.registry.RegistryReader;
import dev.quantumfusion.dashloader.registry.RegistryWriter;
import dev.quantumfusion.dashloader.thread.ThreadHandler;
import dev.quantumfusion.dashloader.util.TimeUtil;
import dev.quantumfusion.taski.builtin.StepTask;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1091;
import net.minecraft.class_2960;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DashLoader {
    private static final String VERSION = ((ModContainer)FabricLoader.getInstance().getModContainer("dashloader").orElseThrow(() -> new IllegalStateException("DashLoader not found... apparently! WTF?"))).getMetadata().getVersion().getFriendlyString();
    public static final Logger LOG = LogManager.getLogger((String)"DashLoader");
    public static final DashLoader DL = new DashLoader();
    private boolean shouldReload = true;
    private Status status = Status.NONE;
    private final DashMetadata metadata = new DashMetadata();
    private DashDataManager dataManager;
    public final APIHandler api;
    public final RegistryHandler registry;
    public final ThreadHandler thread;
    public final ProgressHandler progress;
    public final ConfigHandler config;
    public final IOHandler io;
    public final ProfilerHandler profilerHandler = new ProfilerHandler();

    public static void bootstrap() {
    }

    private DashLoader() {
        LOG.info("Bootstrapping DashLoader " + VERSION + ".");
        this.api = new APIHandler();
        this.metadata.setModHash(FabricLoader.getInstance());
        this.io = new IOHandler(Path.of("./dashloader-cache/", new String[0]));
        this.config = new ConfigHandler(FabricLoader.getInstance().getConfigDir().normalize().resolve("dashloader.json"));
        this.thread = new ThreadHandler();
        this.progress = new ProgressHandler();
        this.registry = new RegistryHandler();
    }

    public void initialize() {
        LOG.info("Initializing DashLoader " + VERSION + ".");
        try {
            this.api.initAPI();
            List<DashObjectClass<?, ?>> dashObjects = this.api.getDashObjects();
            this.config.reloadConfig();
            FabricLoader instance = FabricLoader.getInstance();
            if (instance.isDevelopmentEnvironment()) {
                LOG.warn("DashLoader launched in dev.");
            }
            this.io.setCacheArea(this.metadata.modInfo);
            this.io.setSubCacheArea("bootstrap");
            this.io.addSerializer(RegistryData.class, dashObjects, DashBlockState.class, DashFont.class, DashSprite.class, DashPredicate.class);
            this.io.addSerializer(ImageData.class, dashObjects, DashImage.class);
            this.io.addSerializer(ModelData.class, dashObjects, DashModel.class);
            this.io.addSerializer(IdentifierData.class, dashObjects, DashIdentifierInterface.class);
            this.io.addSerializer(BakedQuadData.class, dashObjects, DashBakedQuad.class);
            this.io.addSerializer(MappingData.class, dashObjects, new Class[0]);
            LOG.info("Created DashLoader with {}.", (Object)Thread.currentThread().getContextClassLoader().getClass().getSimpleName());
            LOG.info("Initialized DashLoader");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("mc exception bad");
        }
    }

    public DashDataManager getData() {
        DashDataManager dataManager = this.dataManager;
        if (this.dataManager == null) {
            throw new NullPointerException("No dataManager active");
        }
        return dataManager;
    }

    public void reload(List<String> resourcePacks) {
        if (this.shouldReload) {
            this.metadata.setResourcePackHash(resourcePacks);
            this.io.setSubCacheArea(this.metadata.resourcePacks);
            LOG.info("Reloading DashLoader. [mod-hash: {}] [resource-hash: {}]", (Object)this.metadata.modInfo, (Object)this.metadata.resourcePacks);
            if (this.io.cacheExists()) {
                this.setStatus(Status.READ);
                this.loadDashCache();
            } else {
                this.setStatus(Status.WRITE);
            }
            LOG.info("Reloaded DashLoader");
            this.shouldReload = false;
        }
    }

    public void requestReload() {
        this.shouldReload = true;
    }

    public void resetDashLoader() {
        this.setStatus(Status.NONE);
    }

    public void saveDashCache() {
        this.api.callHook(SaveCacheHook.class, SaveCacheHook::saveCacheStart);
        DashCachingScreen.STATUS = DashCachingScreen.Status.CACHING;
        LOG.info("Starting DashLoader Caching");
        try {
            long start = System.currentTimeMillis();
            StepTask main = new StepTask("Creating DashCache", 12);
            this.api.callHook(SaveCacheHook.class, hook -> hook.saveCacheTask(main));
            ProgressHandler.TASK = main;
            this.progress.setCurrentTask("initializing");
            HashMap callbacks = new HashMap();
            callbacks.put(DashModel.class, (rraw, registry) -> {
                DashDataManager.DashWriteContextData writeContextData = this.getData().getWriteContextData();
                if (writeContextData.missingModelsWrite.containsKey(rraw)) {
                    return (DashModel)writeContextData.missingModelsWrite.get(rraw);
                }
                DashMissingDashModel value = new DashMissingDashModel();
                writeContextData.missingModelsWrite.put(rraw, (Object)value);
                return value;
            });
            callbacks.put(DashIdentifierInterface.class, (rraw, registry) -> {
                if (rraw instanceof class_1091) {
                    class_1091 m = (class_1091)rraw;
                    return new DashModelIdentifier(m);
                }
                return new DashIdentifier((class_2960)rraw);
            });
            this.api.callHook(SaveCacheHook.class, hook -> hook.saveCacheRegistryInit(this.registry));
            RegistryWriter writer = this.registry.createWriter(callbacks, this.api.getDashObjects());
            this.api.callHook(SaveCacheHook.class, hook -> hook.saveCacheRegistryWriterInit(writer));
            MappingData mappings = new MappingData();
            this.api.callHook(SaveCacheHook.class, hook -> hook.saveCacheMappingStart(writer, mappings));
            mappings.map(writer, main);
            this.api.callHook(SaveCacheHook.class, hook -> hook.saveCacheMappingEnd(writer, mappings));
            ArrayList holders = new ArrayList();
            this.progress.setCurrentTask("export.image");
            main.run(() -> holders.add(new ImageData(writer)));
            this.progress.setCurrentTask("export.model");
            main.run(() -> holders.add(new ModelData(writer)));
            this.progress.setCurrentTask("export.registry");
            main.run(() -> holders.add(new RegistryData(writer)));
            this.progress.setCurrentTask("export.identifier");
            main.run(() -> holders.add(new IdentifierData(writer)));
            this.progress.setCurrentTask("export.quad");
            main.run(() -> holders.add(new BakedQuadData(writer)));
            this.api.callHook(SaveCacheHook.class, hook -> hook.saveCachePopulateHolders(writer, mappings, holders));
            holders.forEach(holder -> main.run(() -> this.io.save(holder, arg_0 -> ((StepTask)main).setSubTask(arg_0))));
            main.run(() -> this.io.save(mappings, arg_0 -> ((StepTask)main).setSubTask(arg_0)));
            this.api.callHook(SaveCacheHook.class, hook -> hook.saveCacheSerialize(writer, mappings, holders));
            LOG.info("Created cache in " + TimeUtil.getTimeStringFromStart(start));
            DashCachingScreen.STATUS = DashCachingScreen.Status.DONE;
            this.api.callHook(SaveCacheHook.class, SaveCacheHook::saveCacheEnd);
        }
        catch (Throwable thr) {
            this.setStatus(Status.WRITE);
            LOG.error("Failed caching", thr);
            DashCachingScreen.STATUS = DashCachingScreen.Status.CRASHED;
            this.io.clearCache();
        }
    }

    private void loadDashCache() {
        this.api.callHook(LoadCacheHook.class, LoadCacheHook::loadCacheStart);
        long start = System.currentTimeMillis();
        this.io.setSubCacheArea(this.metadata.resourcePacks);
        LOG.info("Starting DashLoader Deserialization");
        try {
            StepTask task = new StepTask("Loading DashCache", 3);
            this.api.callHook(LoadCacheHook.class, hook -> hook.loadCacheTask(task));
            ProgressHandler.TASK = task;
            AtomicReference mappingsReference = new AtomicReference();
            ChunkHolder[] registryDataObjects = new ChunkHolder[5];
            long tempStart = System.currentTimeMillis();
            this.api.callHook(LoadCacheHook.class, LoadCacheHook::loadCacheDeserialization);
            this.thread.parallelRunnable(() -> {
                registryDataObjects[0] = this.io.load(RegistryData.class);
            }, () -> {
                registryDataObjects[1] = this.io.load(ImageData.class);
            }, () -> {
                registryDataObjects[2] = this.io.load(ModelData.class);
            }, () -> {
                registryDataObjects[3] = this.io.load(IdentifierData.class);
            }, () -> {
                registryDataObjects[4] = this.io.load(BakedQuadData.class);
            }, () -> mappingsReference.set(this.io.load(MappingData.class)));
            this.profilerHandler.export_file_reading_time = System.currentTimeMillis() - tempStart;
            MappingData mappings = (MappingData)mappingsReference.get();
            assert (mappings != null);
            LOG.info("Creating Registry");
            RegistryReader reader = this.registry.createReader(registryDataObjects);
            this.api.callHook(LoadCacheHook.class, hook -> hook.loadCacheRegistryInit(reader, this.dataManager, mappings));
            tempStart = System.currentTimeMillis();
            LOG.info("Exporting Mappings");
            task.run(() -> {
                reader.export(arg_0 -> ((StepTask)task).setSubTask(arg_0));
                this.api.callHook(LoadCacheHook.class, hook -> hook.loadCacheExported(reader, this.dataManager, mappings));
            });
            this.profilerHandler.export_asset_exporting_time = System.currentTimeMillis() - tempStart;
            tempStart = System.currentTimeMillis();
            LOG.info("Loading Mappings");
            task.run(() -> {
                mappings.export(reader, this.dataManager, arg_0 -> ((StepTask)task).setSubTask(arg_0));
                this.api.callHook(LoadCacheHook.class, hook -> hook.loadCacheMapped(reader, this.dataManager, mappings));
            });
            this.profilerHandler.export_asset_loading_time = System.currentTimeMillis() - tempStart;
            this.profilerHandler.export_time = System.currentTimeMillis() - start;
            LOG.info("Loaded DashLoader in {}ms", (Object)this.profilerHandler.export_time);
            this.api.callHook(LoadCacheHook.class, LoadCacheHook::loadCacheEnd);
        }
        catch (Exception e) {
            LOG.error("Summoned CrashLoader in {}", (Object)TimeUtil.getTimeStringFromStart(start), (Object)e);
            this.setStatus(Status.WRITE);
            this.io.clearCache();
        }
    }

    private void setStatus(Status status) {
        LOG.info("\u001b[46m\u001b[30m DashLoader Status change {}\n\u001b[0m", (Object)status);
        this.status = status;
        switch (status) {
            case NONE: {
                this.dataManager = null;
                break;
            }
            case READ: {
                this.dataManager = new DashDataManager(new DashDataManager.DashReadContextData());
                break;
            }
            case WRITE: {
                this.dataManager = new DashDataManager(new DashDataManager.DashWriteContextData());
            }
        }
    }

    public boolean active() {
        return this.status != Status.NONE;
    }

    public boolean isWrite() {
        return this.status == Status.WRITE;
    }

    public boolean isRead() {
        return this.status == Status.READ;
    }

    public Status getStatus() {
        return this.status;
    }

    public static enum Status {
        NONE,
        READ,
        WRITE;

    }

    public static class DashMetadata {
        public String modInfo;
        public String resourcePacks;

        public void setModHash(FabricLoader loader) {
            ModMetadata metadata;
            ArrayList<ModMetadata> versions = new ArrayList<ModMetadata>();
            for (ModContainer mod : loader.getAllMods()) {
                metadata = mod.getMetadata();
                versions.add(metadata);
            }
            versions.sort(Comparator.comparing(ModMetadata::getId));
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < versions.size(); ++i) {
                metadata = (ModMetadata)versions.get(i);
                stringBuilder.append(i).append("$").append(metadata.getId()).append('&').append(metadata.getVersion().getFriendlyString());
            }
            this.modInfo = DigestUtils.md5Hex((String)stringBuilder.toString()).toUpperCase();
        }

        public void setResourcePackHash(List<String> resourcePacks) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < resourcePacks.size(); ++i) {
                String resourcePack = resourcePacks.get(i);
                stringBuilder.append(i).append("$").append(resourcePack);
            }
            this.resourcePacks = DigestUtils.md5Hex((String)stringBuilder.toString()).toUpperCase();
        }
    }
}

